# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .address import Address
from .bank_account import BankAccount
from .custom_field_data import CustomFieldData
from .dependent import Dependent
from .education import Education
from .email import Email
from .emergency_contact import EmergencyContact
from .enum import Enum
from .national_id import NationalId
from .person_info_chn import PersonInfoChn
from .person_name import PersonName
from .personal_profile import PersonalProfile
from .phone import Phone
from .resident_tax import ResidentTax
from .work_experience_info import WorkExperienceInfo


class PersonInfo(object):
    _types = {
        "person_id": str,
        "phone_number": str,
        "legal_name": str,
        "preferred_name": str,
        "preferred_local_full_name": str,
        "preferred_english_full_name": str,
        "name_list": List[PersonName],
        "gender": Enum,
        "date_of_birth": str,
        "nationality_id_v2": str,
        "race": Enum,
        "marital_status": Enum,
        "phone_list": List[Phone],
        "address_list": List[Address],
        "email_list": List[Email],
        "work_experience_list": List[WorkExperienceInfo],
        "education_list": List[Education],
        "bank_account_list": List[BankAccount],
        "national_id_list": List[NationalId],
        "dependent_list": List[Dependent],
        "emergency_contact_list": List[EmergencyContact],
        "date_entered_workforce": str,
        "working_years": int,
        "profile_image_id": str,
        "email_address": str,
        "age": int,
        "highest_level_of_education": Education,
        "highest_degree_of_education": Education,
        "personal_profile": List[PersonalProfile],
        "native_region": str,
        "hukou_type": Enum,
        "hukou_location": str,
        "talent_id": str,
        "custom_fields": List[CustomFieldData],
        "national_id_number": str,
        "family_address": str,
        "person_info_chns": List[PersonInfoChn],
        "born_country_region": str,
        "is_disabled": bool,
        "disable_card_number": str,
        "is_martyr_family": bool,
        "martyr_card_number": str,
        "is_old_alone": bool,
        "resident_taxes": List[ResidentTax],
        "first_entry_time": str,
        "leave_time": str,
        "religion": Enum,
    }

    def __init__(self, d=None):
        self.person_id: Optional[str] = None
        self.phone_number: Optional[str] = None
        self.legal_name: Optional[str] = None
        self.preferred_name: Optional[str] = None
        self.preferred_local_full_name: Optional[str] = None
        self.preferred_english_full_name: Optional[str] = None
        self.name_list: Optional[List[PersonName]] = None
        self.gender: Optional[Enum] = None
        self.date_of_birth: Optional[str] = None
        self.nationality_id_v2: Optional[str] = None
        self.race: Optional[Enum] = None
        self.marital_status: Optional[Enum] = None
        self.phone_list: Optional[List[Phone]] = None
        self.address_list: Optional[List[Address]] = None
        self.email_list: Optional[List[Email]] = None
        self.work_experience_list: Optional[List[WorkExperienceInfo]] = None
        self.education_list: Optional[List[Education]] = None
        self.bank_account_list: Optional[List[BankAccount]] = None
        self.national_id_list: Optional[List[NationalId]] = None
        self.dependent_list: Optional[List[Dependent]] = None
        self.emergency_contact_list: Optional[List[EmergencyContact]] = None
        self.date_entered_workforce: Optional[str] = None
        self.working_years: Optional[int] = None
        self.profile_image_id: Optional[str] = None
        self.email_address: Optional[str] = None
        self.age: Optional[int] = None
        self.highest_level_of_education: Optional[Education] = None
        self.highest_degree_of_education: Optional[Education] = None
        self.personal_profile: Optional[List[PersonalProfile]] = None
        self.native_region: Optional[str] = None
        self.hukou_type: Optional[Enum] = None
        self.hukou_location: Optional[str] = None
        self.talent_id: Optional[str] = None
        self.custom_fields: Optional[List[CustomFieldData]] = None
        self.national_id_number: Optional[str] = None
        self.family_address: Optional[str] = None
        self.person_info_chns: Optional[List[PersonInfoChn]] = None
        self.born_country_region: Optional[str] = None
        self.is_disabled: Optional[bool] = None
        self.disable_card_number: Optional[str] = None
        self.is_martyr_family: Optional[bool] = None
        self.martyr_card_number: Optional[str] = None
        self.is_old_alone: Optional[bool] = None
        self.resident_taxes: Optional[List[ResidentTax]] = None
        self.first_entry_time: Optional[str] = None
        self.leave_time: Optional[str] = None
        self.religion: Optional[Enum] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PersonInfoBuilder":
        return PersonInfoBuilder()


class PersonInfoBuilder(object):
    def __init__(self) -> None:
        self._person_info = PersonInfo()

    def person_id(self, person_id: str) -> "PersonInfoBuilder":
        self._person_info.person_id = person_id
        return self

    def phone_number(self, phone_number: str) -> "PersonInfoBuilder":
        self._person_info.phone_number = phone_number
        return self

    def legal_name(self, legal_name: str) -> "PersonInfoBuilder":
        self._person_info.legal_name = legal_name
        return self

    def preferred_name(self, preferred_name: str) -> "PersonInfoBuilder":
        self._person_info.preferred_name = preferred_name
        return self

    def preferred_local_full_name(self, preferred_local_full_name: str) -> "PersonInfoBuilder":
        self._person_info.preferred_local_full_name = preferred_local_full_name
        return self

    def preferred_english_full_name(self, preferred_english_full_name: str) -> "PersonInfoBuilder":
        self._person_info.preferred_english_full_name = preferred_english_full_name
        return self

    def name_list(self, name_list: List[PersonName]) -> "PersonInfoBuilder":
        self._person_info.name_list = name_list
        return self

    def gender(self, gender: Enum) -> "PersonInfoBuilder":
        self._person_info.gender = gender
        return self

    def date_of_birth(self, date_of_birth: str) -> "PersonInfoBuilder":
        self._person_info.date_of_birth = date_of_birth
        return self

    def nationality_id_v2(self, nationality_id_v2: str) -> "PersonInfoBuilder":
        self._person_info.nationality_id_v2 = nationality_id_v2
        return self

    def race(self, race: Enum) -> "PersonInfoBuilder":
        self._person_info.race = race
        return self

    def marital_status(self, marital_status: Enum) -> "PersonInfoBuilder":
        self._person_info.marital_status = marital_status
        return self

    def phone_list(self, phone_list: List[Phone]) -> "PersonInfoBuilder":
        self._person_info.phone_list = phone_list
        return self

    def address_list(self, address_list: List[Address]) -> "PersonInfoBuilder":
        self._person_info.address_list = address_list
        return self

    def email_list(self, email_list: List[Email]) -> "PersonInfoBuilder":
        self._person_info.email_list = email_list
        return self

    def work_experience_list(self, work_experience_list: List[WorkExperienceInfo]) -> "PersonInfoBuilder":
        self._person_info.work_experience_list = work_experience_list
        return self

    def education_list(self, education_list: List[Education]) -> "PersonInfoBuilder":
        self._person_info.education_list = education_list
        return self

    def bank_account_list(self, bank_account_list: List[BankAccount]) -> "PersonInfoBuilder":
        self._person_info.bank_account_list = bank_account_list
        return self

    def national_id_list(self, national_id_list: List[NationalId]) -> "PersonInfoBuilder":
        self._person_info.national_id_list = national_id_list
        return self

    def dependent_list(self, dependent_list: List[Dependent]) -> "PersonInfoBuilder":
        self._person_info.dependent_list = dependent_list
        return self

    def emergency_contact_list(self, emergency_contact_list: List[EmergencyContact]) -> "PersonInfoBuilder":
        self._person_info.emergency_contact_list = emergency_contact_list
        return self

    def date_entered_workforce(self, date_entered_workforce: str) -> "PersonInfoBuilder":
        self._person_info.date_entered_workforce = date_entered_workforce
        return self

    def working_years(self, working_years: int) -> "PersonInfoBuilder":
        self._person_info.working_years = working_years
        return self

    def profile_image_id(self, profile_image_id: str) -> "PersonInfoBuilder":
        self._person_info.profile_image_id = profile_image_id
        return self

    def email_address(self, email_address: str) -> "PersonInfoBuilder":
        self._person_info.email_address = email_address
        return self

    def age(self, age: int) -> "PersonInfoBuilder":
        self._person_info.age = age
        return self

    def highest_level_of_education(self, highest_level_of_education: Education) -> "PersonInfoBuilder":
        self._person_info.highest_level_of_education = highest_level_of_education
        return self

    def highest_degree_of_education(self, highest_degree_of_education: Education) -> "PersonInfoBuilder":
        self._person_info.highest_degree_of_education = highest_degree_of_education
        return self

    def personal_profile(self, personal_profile: List[PersonalProfile]) -> "PersonInfoBuilder":
        self._person_info.personal_profile = personal_profile
        return self

    def native_region(self, native_region: str) -> "PersonInfoBuilder":
        self._person_info.native_region = native_region
        return self

    def hukou_type(self, hukou_type: Enum) -> "PersonInfoBuilder":
        self._person_info.hukou_type = hukou_type
        return self

    def hukou_location(self, hukou_location: str) -> "PersonInfoBuilder":
        self._person_info.hukou_location = hukou_location
        return self

    def talent_id(self, talent_id: str) -> "PersonInfoBuilder":
        self._person_info.talent_id = talent_id
        return self

    def custom_fields(self, custom_fields: List[CustomFieldData]) -> "PersonInfoBuilder":
        self._person_info.custom_fields = custom_fields
        return self

    def national_id_number(self, national_id_number: str) -> "PersonInfoBuilder":
        self._person_info.national_id_number = national_id_number
        return self

    def family_address(self, family_address: str) -> "PersonInfoBuilder":
        self._person_info.family_address = family_address
        return self

    def person_info_chns(self, person_info_chns: List[PersonInfoChn]) -> "PersonInfoBuilder":
        self._person_info.person_info_chns = person_info_chns
        return self

    def born_country_region(self, born_country_region: str) -> "PersonInfoBuilder":
        self._person_info.born_country_region = born_country_region
        return self

    def is_disabled(self, is_disabled: bool) -> "PersonInfoBuilder":
        self._person_info.is_disabled = is_disabled
        return self

    def disable_card_number(self, disable_card_number: str) -> "PersonInfoBuilder":
        self._person_info.disable_card_number = disable_card_number
        return self

    def is_martyr_family(self, is_martyr_family: bool) -> "PersonInfoBuilder":
        self._person_info.is_martyr_family = is_martyr_family
        return self

    def martyr_card_number(self, martyr_card_number: str) -> "PersonInfoBuilder":
        self._person_info.martyr_card_number = martyr_card_number
        return self

    def is_old_alone(self, is_old_alone: bool) -> "PersonInfoBuilder":
        self._person_info.is_old_alone = is_old_alone
        return self

    def resident_taxes(self, resident_taxes: List[ResidentTax]) -> "PersonInfoBuilder":
        self._person_info.resident_taxes = resident_taxes
        return self

    def first_entry_time(self, first_entry_time: str) -> "PersonInfoBuilder":
        self._person_info.first_entry_time = first_entry_time
        return self

    def leave_time(self, leave_time: str) -> "PersonInfoBuilder":
        self._person_info.leave_time = leave_time
        return self

    def religion(self, religion: Enum) -> "PersonInfoBuilder":
        self._person_info.religion = religion
        return self

    def build(self) -> "PersonInfo":
        return self._person_info
