# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class PreHireContractInfo(object):
    _types = {
        "contract_start_date": str,
        "contract_end_date": str,
        "contract_type": str,
        "duration_type": str,
        "signing_type": str,
    }

    def __init__(self, d=None):
        self.contract_start_date: Optional[str] = None
        self.contract_end_date: Optional[str] = None
        self.contract_type: Optional[str] = None
        self.duration_type: Optional[str] = None
        self.signing_type: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PreHireContractInfoBuilder":
        return PreHireContractInfoBuilder()


class PreHireContractInfoBuilder(object):
    def __init__(self) -> None:
        self._pre_hire_contract_info = PreHireContractInfo()

    def contract_start_date(self, contract_start_date: str) -> "PreHireContractInfoBuilder":
        self._pre_hire_contract_info.contract_start_date = contract_start_date
        return self

    def contract_end_date(self, contract_end_date: str) -> "PreHireContractInfoBuilder":
        self._pre_hire_contract_info.contract_end_date = contract_end_date
        return self

    def contract_type(self, contract_type: str) -> "PreHireContractInfoBuilder":
        self._pre_hire_contract_info.contract_type = contract_type
        return self

    def duration_type(self, duration_type: str) -> "PreHireContractInfoBuilder":
        self._pre_hire_contract_info.duration_type = duration_type
        return self

    def signing_type(self, signing_type: str) -> "PreHireContractInfoBuilder":
        self._pre_hire_contract_info.signing_type = signing_type
        return self

    def build(self) -> "PreHireContractInfo":
        return self._pre_hire_contract_info
