# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .basic_info import BasicInfo
from .education_info import EducationInfo
from .offer_info import OfferInfo
from .work_experience import WorkExperience


class PrehireCreate(object):
    _types = {
        "basic_info": BasicInfo,
        "offer_info": OfferInfo,
        "education_info": List[EducationInfo],
        "work_experience": List[WorkExperience],
        "ats_application_id": str,
    }

    def __init__(self, d=None):
        self.basic_info: Optional[BasicInfo] = None
        self.offer_info: Optional[OfferInfo] = None
        self.education_info: Optional[List[EducationInfo]] = None
        self.work_experience: Optional[List[WorkExperience]] = None
        self.ats_application_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "PrehireCreateBuilder":
        return PrehireCreateBuilder()


class PrehireCreateBuilder(object):
    def __init__(self) -> None:
        self._prehire_create = PrehireCreate()

    def basic_info(self, basic_info: BasicInfo) -> "PrehireCreateBuilder":
        self._prehire_create.basic_info = basic_info
        return self

    def offer_info(self, offer_info: OfferInfo) -> "PrehireCreateBuilder":
        self._prehire_create.offer_info = offer_info
        return self

    def education_info(self, education_info: List[EducationInfo]) -> "PrehireCreateBuilder":
        self._prehire_create.education_info = education_info
        return self

    def work_experience(self, work_experience: List[WorkExperience]) -> "PrehireCreateBuilder":
        self._prehire_create.work_experience = work_experience
        return self

    def ats_application_id(self, ats_application_id: str) -> "PrehireCreateBuilder":
        self._prehire_create.ats_application_id = ats_application_id
        return self

    def build(self) -> "PrehireCreate":
        return self._prehire_create
