# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ProcessLink(object):
    _types = {
        "web_link": str,
        "pc_link": str,
        "mobile_link": str,
    }

    def __init__(self, d=None):
        self.web_link: Optional[str] = None
        self.pc_link: Optional[str] = None
        self.mobile_link: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ProcessLinkBuilder":
        return ProcessLinkBuilder()


class ProcessLinkBuilder(object):
    def __init__(self) -> None:
        self._process_link = ProcessLink()

    def web_link(self, web_link: str) -> "ProcessLinkBuilder":
        self._process_link.web_link = web_link
        return self

    def pc_link(self, pc_link: str) -> "ProcessLinkBuilder":
        self._process_link.pc_link = pc_link
        return self

    def mobile_link(self, mobile_link: str) -> "ProcessLinkBuilder":
        self._process_link.mobile_link = mobile_link
        return self

    def build(self) -> "ProcessLink":
        return self._process_link
