# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .change_field_pair import ChangeFieldPair
from .cost_center import CostCenter
from .enum import Enum
from .i18n import I18n


class ReorganizationInfo(object):
    _types = {
        "original_department_names": List[I18n],
        "target_department_names": List[I18n],
        "original_department_code": str,
        "target_department_code": str,
        "original_sub_type": Enum,
        "target_sub_type": Enum,
        "original_department_manager": str,
        "target_department_manager": str,
        "original_descriptions": List[I18n],
        "target_descriptions": List[I18n],
        "original_cost_center": CostCenter,
        "target_cost_center": CostCenter,
        "original_is_confidential": bool,
        "target_is_confidential": bool,
        "original_staffing_model": bool,
        "target_staffing_model": bool,
        "original_parent_department_id": str,
        "target_parent_department_id": str,
        "custom_fields": List[ChangeFieldPair],
    }

    def __init__(self, d=None):
        self.original_department_names: Optional[List[I18n]] = None
        self.target_department_names: Optional[List[I18n]] = None
        self.original_department_code: Optional[str] = None
        self.target_department_code: Optional[str] = None
        self.original_sub_type: Optional[Enum] = None
        self.target_sub_type: Optional[Enum] = None
        self.original_department_manager: Optional[str] = None
        self.target_department_manager: Optional[str] = None
        self.original_descriptions: Optional[List[I18n]] = None
        self.target_descriptions: Optional[List[I18n]] = None
        self.original_cost_center: Optional[CostCenter] = None
        self.target_cost_center: Optional[CostCenter] = None
        self.original_is_confidential: Optional[bool] = None
        self.target_is_confidential: Optional[bool] = None
        self.original_staffing_model: Optional[bool] = None
        self.target_staffing_model: Optional[bool] = None
        self.original_parent_department_id: Optional[str] = None
        self.target_parent_department_id: Optional[str] = None
        self.custom_fields: Optional[List[ChangeFieldPair]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ReorganizationInfoBuilder":
        return ReorganizationInfoBuilder()


class ReorganizationInfoBuilder(object):
    def __init__(self) -> None:
        self._reorganization_info = ReorganizationInfo()

    def original_department_names(self, original_department_names: List[I18n]) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_department_names = original_department_names
        return self

    def target_department_names(self, target_department_names: List[I18n]) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_department_names = target_department_names
        return self

    def original_department_code(self, original_department_code: str) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_department_code = original_department_code
        return self

    def target_department_code(self, target_department_code: str) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_department_code = target_department_code
        return self

    def original_sub_type(self, original_sub_type: Enum) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_sub_type = original_sub_type
        return self

    def target_sub_type(self, target_sub_type: Enum) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_sub_type = target_sub_type
        return self

    def original_department_manager(self, original_department_manager: str) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_department_manager = original_department_manager
        return self

    def target_department_manager(self, target_department_manager: str) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_department_manager = target_department_manager
        return self

    def original_descriptions(self, original_descriptions: List[I18n]) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_descriptions = original_descriptions
        return self

    def target_descriptions(self, target_descriptions: List[I18n]) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_descriptions = target_descriptions
        return self

    def original_cost_center(self, original_cost_center: CostCenter) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_cost_center = original_cost_center
        return self

    def target_cost_center(self, target_cost_center: CostCenter) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_cost_center = target_cost_center
        return self

    def original_is_confidential(self, original_is_confidential: bool) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_is_confidential = original_is_confidential
        return self

    def target_is_confidential(self, target_is_confidential: bool) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_is_confidential = target_is_confidential
        return self

    def original_staffing_model(self, original_staffing_model: bool) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_staffing_model = original_staffing_model
        return self

    def target_staffing_model(self, target_staffing_model: bool) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_staffing_model = target_staffing_model
        return self

    def original_parent_department_id(self, original_parent_department_id: str) -> "ReorganizationInfoBuilder":
        self._reorganization_info.original_parent_department_id = original_parent_department_id
        return self

    def target_parent_department_id(self, target_parent_department_id: str) -> "ReorganizationInfoBuilder":
        self._reorganization_info.target_parent_department_id = target_parent_department_id
        return self

    def custom_fields(self, custom_fields: List[ChangeFieldPair]) -> "ReorganizationInfoBuilder":
        self._reorganization_info.custom_fields = custom_fields
        return self

    def build(self) -> "ReorganizationInfo":
        return self._reorganization_info
