# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .bank import Bank


class SearchBasicInfoBankResponseBody(object):
    _types = {
        "items": List[Bank],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Bank]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchBasicInfoBankResponseBodyBuilder":
        return SearchBasicInfoBankResponseBodyBuilder()


class SearchBasicInfoBankResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_basic_info_bank_response_body = SearchBasicInfoBankResponseBody()

    def items(self, items: List[Bank]) -> "SearchBasicInfoBankResponseBodyBuilder":
        self._search_basic_info_bank_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "SearchBasicInfoBankResponseBodyBuilder":
        self._search_basic_info_bank_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "SearchBasicInfoBankResponseBodyBuilder":
        self._search_basic_info_bank_response_body.has_more = has_more
        return self

    def build(self) -> "SearchBasicInfoBankResponseBody":
        return self._search_basic_info_bank_response_body
