# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .city import City


class SearchBasicInfoCityResponseBody(object):
    _types = {
        "items": List[City],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[City]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchBasicInfoCityResponseBodyBuilder":
        return SearchBasicInfoCityResponseBodyBuilder()


class SearchBasicInfoCityResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_basic_info_city_response_body = SearchBasicInfoCityResponseBody()

    def items(self, items: List[City]) -> "SearchBasicInfoCityResponseBodyBuilder":
        self._search_basic_info_city_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "SearchBasicInfoCityResponseBodyBuilder":
        self._search_basic_info_city_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "SearchBasicInfoCityResponseBodyBuilder":
        self._search_basic_info_city_response_body.has_more = has_more
        return self

    def build(self) -> "SearchBasicInfoCityResponseBody":
        return self._search_basic_info_city_response_body
