# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .search_basic_info_country_region_subdivision_request_body import \
    SearchBasicInfoCountryRegionSubdivisionRequestBody


class SearchBasicInfoCountryRegionSubdivisionRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.request_body: Optional[SearchBasicInfoCountryRegionSubdivisionRequestBody] = None

    @staticmethod
    def builder() -> "SearchBasicInfoCountryRegionSubdivisionRequestBuilder":
        return SearchBasicInfoCountryRegionSubdivisionRequestBuilder()


class SearchBasicInfoCountryRegionSubdivisionRequestBuilder(object):

    def __init__(self) -> None:
        search_basic_info_country_region_subdivision_request = SearchBasicInfoCountryRegionSubdivisionRequest()
        search_basic_info_country_region_subdivision_request.http_method = HttpMethod.POST
        search_basic_info_country_region_subdivision_request.uri = "/open-apis/corehr/v2/basic_info/country_region_subdivisions/search"
        search_basic_info_country_region_subdivision_request.token_types = {AccessTokenType.TENANT}
        self._search_basic_info_country_region_subdivision_request: SearchBasicInfoCountryRegionSubdivisionRequest = search_basic_info_country_region_subdivision_request

    def page_size(self, page_size: int) -> "SearchBasicInfoCountryRegionSubdivisionRequestBuilder":
        self._search_basic_info_country_region_subdivision_request.page_size = page_size
        self._search_basic_info_country_region_subdivision_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "SearchBasicInfoCountryRegionSubdivisionRequestBuilder":
        self._search_basic_info_country_region_subdivision_request.page_token = page_token
        self._search_basic_info_country_region_subdivision_request.add_query("page_token", page_token)
        return self

    def request_body(self,
                     request_body: SearchBasicInfoCountryRegionSubdivisionRequestBody) -> "SearchBasicInfoCountryRegionSubdivisionRequestBuilder":
        self._search_basic_info_country_region_subdivision_request.request_body = request_body
        self._search_basic_info_country_region_subdivision_request.body = request_body
        return self

    def build(self) -> SearchBasicInfoCountryRegionSubdivisionRequest:
        return self._search_basic_info_country_region_subdivision_request
