# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .contract import Contract


class SearchContractResponseBody(object):
    _types = {
        "items": List[Contract],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Contract]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchContractResponseBodyBuilder":
        return SearchContractResponseBodyBuilder()


class SearchContractResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_contract_response_body = SearchContractResponseBody()

    def items(self, items: List[Contract]) -> "SearchContractResponseBodyBuilder":
        self._search_contract_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "SearchContractResponseBodyBuilder":
        self._search_contract_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "SearchContractResponseBodyBuilder":
        self._search_contract_response_body.has_more = has_more
        return self

    def build(self) -> "SearchContractResponseBody":
        return self._search_contract_response_body
