# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init


class SearchCostCenterRequestBody(object):
    _types = {
        "cost_center_id_list": List[str],
        "name_list": List[str],
        "code": str,
        "parent_cost_center_id": str,
        "get_all_version": bool,
    }

    def __init__(self, d=None):
        self.cost_center_id_list: Optional[List[str]] = None
        self.name_list: Optional[List[str]] = None
        self.code: Optional[str] = None
        self.parent_cost_center_id: Optional[str] = None
        self.get_all_version: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchCostCenterRequestBodyBuilder":
        return SearchCostCenterRequestBodyBuilder()


class SearchCostCenterRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._search_cost_center_request_body = SearchCostCenterRequestBody()

    def cost_center_id_list(self, cost_center_id_list: List[str]) -> "SearchCostCenterRequestBodyBuilder":
        self._search_cost_center_request_body.cost_center_id_list = cost_center_id_list
        return self

    def name_list(self, name_list: List[str]) -> "SearchCostCenterRequestBodyBuilder":
        self._search_cost_center_request_body.name_list = name_list
        return self

    def code(self, code: str) -> "SearchCostCenterRequestBodyBuilder":
        self._search_cost_center_request_body.code = code
        return self

    def parent_cost_center_id(self, parent_cost_center_id: str) -> "SearchCostCenterRequestBodyBuilder":
        self._search_cost_center_request_body.parent_cost_center_id = parent_cost_center_id
        return self

    def get_all_version(self, get_all_version: bool) -> "SearchCostCenterRequestBodyBuilder":
        self._search_cost_center_request_body.get_all_version = get_all_version
        return self

    def build(self) -> "SearchCostCenterRequestBody":
        return self._search_cost_center_request_body
