# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .department import Department


class SearchDepartmentResponseBody(object):
    _types = {
        "items": List[Department],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[Department]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchDepartmentResponseBodyBuilder":
        return SearchDepartmentResponseBodyBuilder()


class SearchDepartmentResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_department_response_body = SearchDepartmentResponseBody()

    def items(self, items: List[Department]) -> "SearchDepartmentResponseBodyBuilder":
        self._search_department_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "SearchDepartmentResponseBodyBuilder":
        self._search_department_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "SearchDepartmentResponseBodyBuilder":
        self._search_department_response_body.has_more = has_more
        return self

    def build(self) -> "SearchDepartmentResponseBody":
        return self._search_department_response_body
