# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .search_job_change_request_body import SearchJobChangeRequestBody


class SearchJobChangeRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.request_body: Optional[SearchJobChangeRequestBody] = None

    @staticmethod
    def builder() -> "SearchJobChangeRequestBuilder":
        return SearchJobChangeRequestBuilder()


class SearchJobChangeRequestBuilder(object):

    def __init__(self) -> None:
        search_job_change_request = SearchJobChangeRequest()
        search_job_change_request.http_method = HttpMethod.POST
        search_job_change_request.uri = "/open-apis/corehr/v2/job_changes/search"
        search_job_change_request.token_types = {AccessTokenType.TENANT}
        self._search_job_change_request: SearchJobChangeRequest = search_job_change_request

    def page_size(self, page_size: int) -> "SearchJobChangeRequestBuilder":
        self._search_job_change_request.page_size = page_size
        self._search_job_change_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "SearchJobChangeRequestBuilder":
        self._search_job_change_request.page_token = page_token
        self._search_job_change_request.add_query("page_token", page_token)
        return self

    def user_id_type(self, user_id_type: str) -> "SearchJobChangeRequestBuilder":
        self._search_job_change_request.user_id_type = user_id_type
        self._search_job_change_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "SearchJobChangeRequestBuilder":
        self._search_job_change_request.department_id_type = department_id_type
        self._search_job_change_request.add_query("department_id_type", department_id_type)
        return self

    def request_body(self, request_body: SearchJobChangeRequestBody) -> "SearchJobChangeRequestBuilder":
        self._search_job_change_request.request_body = request_body
        self._search_job_change_request.body = request_body
        return self

    def build(self) -> SearchJobChangeRequest:
        return self._search_job_change_request
