# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .search_probation_request_body import SearchProbationRequestBody


class SearchProbationRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.user_id_type: Optional[str] = None
        self.department_id_type: Optional[str] = None
        self.request_body: Optional[SearchProbationRequestBody] = None

    @staticmethod
    def builder() -> "SearchProbationRequestBuilder":
        return SearchProbationRequestBuilder()


class SearchProbationRequestBuilder(object):

    def __init__(self) -> None:
        search_probation_request = SearchProbationRequest()
        search_probation_request.http_method = HttpMethod.POST
        search_probation_request.uri = "/open-apis/corehr/v2/probation/search"
        search_probation_request.token_types = {AccessTokenType.TENANT}
        self._search_probation_request: SearchProbationRequest = search_probation_request

    def page_size(self, page_size: int) -> "SearchProbationRequestBuilder":
        self._search_probation_request.page_size = page_size
        self._search_probation_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "SearchProbationRequestBuilder":
        self._search_probation_request.page_token = page_token
        self._search_probation_request.add_query("page_token", page_token)
        return self

    def user_id_type(self, user_id_type: str) -> "SearchProbationRequestBuilder":
        self._search_probation_request.user_id_type = user_id_type
        self._search_probation_request.add_query("user_id_type", user_id_type)
        return self

    def department_id_type(self, department_id_type: str) -> "SearchProbationRequestBuilder":
        self._search_probation_request.department_id_type = department_id_type
        self._search_probation_request.add_query("department_id_type", department_id_type)
        return self

    def request_body(self, request_body: SearchProbationRequestBody) -> "SearchProbationRequestBuilder":
        self._search_probation_request.request_body = request_body
        self._search_probation_request.body = request_body
        return self

    def build(self) -> SearchProbationRequest:
        return self._search_probation_request
