# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .probation_info import ProbationInfo


class SearchProbationResponseBody(object):
    _types = {
        "items": List[ProbationInfo],
        "page_token": str,
        "has_more": bool,
    }

    def __init__(self, d=None):
        self.items: Optional[List[ProbationInfo]] = None
        self.page_token: Optional[str] = None
        self.has_more: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SearchProbationResponseBodyBuilder":
        return SearchProbationResponseBodyBuilder()


class SearchProbationResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._search_probation_response_body = SearchProbationResponseBody()

    def items(self, items: List[ProbationInfo]) -> "SearchProbationResponseBodyBuilder":
        self._search_probation_response_body.items = items
        return self

    def page_token(self, page_token: str) -> "SearchProbationResponseBodyBuilder":
        self._search_probation_response_body.page_token = page_token
        return self

    def has_more(self, has_more: bool) -> "SearchProbationResponseBodyBuilder":
        self._search_probation_response_body.has_more = has_more
        return self

    def build(self) -> "SearchProbationResponseBody":
        return self._search_probation_response_body
