# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .enum import Enum
from .i18n import I18n


class SignatureFile(object):
    _types = {
        "signature_file_id": str,
        "names": List[I18n],
        "create_time": str,
        "update_time": str,
        "employment_id": str,
        "signature_file_state": Enum,
        "contract_code": str,
    }

    def __init__(self, d=None):
        self.signature_file_id: Optional[str] = None
        self.names: Optional[List[I18n]] = None
        self.create_time: Optional[str] = None
        self.update_time: Optional[str] = None
        self.employment_id: Optional[str] = None
        self.signature_file_state: Optional[Enum] = None
        self.contract_code: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "SignatureFileBuilder":
        return SignatureFileBuilder()


class SignatureFileBuilder(object):
    def __init__(self) -> None:
        self._signature_file = SignatureFile()

    def signature_file_id(self, signature_file_id: str) -> "SignatureFileBuilder":
        self._signature_file.signature_file_id = signature_file_id
        return self

    def names(self, names: List[I18n]) -> "SignatureFileBuilder":
        self._signature_file.names = names
        return self

    def create_time(self, create_time: str) -> "SignatureFileBuilder":
        self._signature_file.create_time = create_time
        return self

    def update_time(self, update_time: str) -> "SignatureFileBuilder":
        self._signature_file.update_time = update_time
        return self

    def employment_id(self, employment_id: str) -> "SignatureFileBuilder":
        self._signature_file.employment_id = employment_id
        return self

    def signature_file_state(self, signature_file_state: Enum) -> "SignatureFileBuilder":
        self._signature_file.signature_file_state = signature_file_state
        return self

    def contract_code(self, contract_code: str) -> "SignatureFileBuilder":
        self._signature_file.contract_code = contract_code
        return self

    def build(self) -> "SignatureFile":
        return self._signature_file
