# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .custom_field_data import CustomFieldData


class TranferEmploymentInfo(object):
    _types = {
        "regular_employee_start_date": str,
        "seniority_date": str,
        "employee_number": str,
        "custom_fields": List[CustomFieldData],
    }

    def __init__(self, d=None):
        self.regular_employee_start_date: Optional[str] = None
        self.seniority_date: Optional[str] = None
        self.employee_number: Optional[str] = None
        self.custom_fields: Optional[List[CustomFieldData]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "TranferEmploymentInfoBuilder":
        return TranferEmploymentInfoBuilder()


class TranferEmploymentInfoBuilder(object):
    def __init__(self) -> None:
        self._tranfer_employment_info = TranferEmploymentInfo()

    def regular_employee_start_date(self, regular_employee_start_date: str) -> "TranferEmploymentInfoBuilder":
        self._tranfer_employment_info.regular_employee_start_date = regular_employee_start_date
        return self

    def seniority_date(self, seniority_date: str) -> "TranferEmploymentInfoBuilder":
        self._tranfer_employment_info.seniority_date = seniority_date
        return self

    def employee_number(self, employee_number: str) -> "TranferEmploymentInfoBuilder":
        self._tranfer_employment_info.employee_number = employee_number
        return self

    def custom_fields(self, custom_fields: List[CustomFieldData]) -> "TranferEmploymentInfoBuilder":
        self._tranfer_employment_info.custom_fields = custom_fields
        return self

    def build(self) -> "TranferEmploymentInfo":
        return self._tranfer_employment_info
