# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .i18n import I18n


class WorkforcePlan(object):
    _types = {
        "workforce_plan_id": str,
        "workforce_plan_name": List[I18n],
        "start_date": str,
        "end_date": str,
        "active": bool,
    }

    def __init__(self, d=None):
        self.workforce_plan_id: Optional[str] = None
        self.workforce_plan_name: Optional[List[I18n]] = None
        self.start_date: Optional[str] = None
        self.end_date: Optional[str] = None
        self.active: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WorkforcePlanBuilder":
        return WorkforcePlanBuilder()


class WorkforcePlanBuilder(object):
    def __init__(self) -> None:
        self._workforce_plan = WorkforcePlan()

    def workforce_plan_id(self, workforce_plan_id: str) -> "WorkforcePlanBuilder":
        self._workforce_plan.workforce_plan_id = workforce_plan_id
        return self

    def workforce_plan_name(self, workforce_plan_name: List[I18n]) -> "WorkforcePlanBuilder":
        self._workforce_plan.workforce_plan_name = workforce_plan_name
        return self

    def start_date(self, start_date: str) -> "WorkforcePlanBuilder":
        self._workforce_plan.start_date = start_date
        return self

    def end_date(self, end_date: str) -> "WorkforcePlanBuilder":
        self._workforce_plan.end_date = end_date
        return self

    def active(self, active: bool) -> "WorkforcePlanBuilder":
        self._workforce_plan.active = active
        return self

    def build(self) -> "WorkforcePlan":
        return self._workforce_plan
