# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .dimension_info import DimensionInfo
from .workforce_plan_eai_detail import WorkforcePlanEaiDetail


class WorkforcePlanDetail(object):
    _types = {
        "workforce_plan_detail_id": str,
        "department": DimensionInfo,
        "employee_type": DimensionInfo,
        "work_location": DimensionInfo,
        "job_family": DimensionInfo,
        "job_level": DimensionInfo,
        "job": DimensionInfo,
        "cost_center": DimensionInfo,
        "workforce_plan": str,
        "estimated_active_individuals_detail": List[WorkforcePlanEaiDetail],
    }

    def __init__(self, d=None):
        self.workforce_plan_detail_id: Optional[str] = None
        self.department: Optional[DimensionInfo] = None
        self.employee_type: Optional[DimensionInfo] = None
        self.work_location: Optional[DimensionInfo] = None
        self.job_family: Optional[DimensionInfo] = None
        self.job_level: Optional[DimensionInfo] = None
        self.job: Optional[DimensionInfo] = None
        self.cost_center: Optional[DimensionInfo] = None
        self.workforce_plan: Optional[str] = None
        self.estimated_active_individuals_detail: Optional[List[WorkforcePlanEaiDetail]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "WorkforcePlanDetailBuilder":
        return WorkforcePlanDetailBuilder()


class WorkforcePlanDetailBuilder(object):
    def __init__(self) -> None:
        self._workforce_plan_detail = WorkforcePlanDetail()

    def workforce_plan_detail_id(self, workforce_plan_detail_id: str) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.workforce_plan_detail_id = workforce_plan_detail_id
        return self

    def department(self, department: DimensionInfo) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.department = department
        return self

    def employee_type(self, employee_type: DimensionInfo) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.employee_type = employee_type
        return self

    def work_location(self, work_location: DimensionInfo) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.work_location = work_location
        return self

    def job_family(self, job_family: DimensionInfo) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.job_family = job_family
        return self

    def job_level(self, job_level: DimensionInfo) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.job_level = job_level
        return self

    def job(self, job: DimensionInfo) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.job = job
        return self

    def cost_center(self, cost_center: DimensionInfo) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.cost_center = cost_center
        return self

    def workforce_plan(self, workforce_plan: str) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.workforce_plan = workforce_plan
        return self

    def estimated_active_individuals_detail(self, estimated_active_individuals_detail: List[
        WorkforcePlanEaiDetail]) -> "WorkforcePlanDetailBuilder":
        self._workforce_plan_detail.estimated_active_individuals_detail = estimated_active_individuals_detail
        return self

    def build(self) -> "WorkforcePlanDetail":
        return self._workforce_plan_detail
