# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.get_by_department_bp_request import GetByDepartmentBpRequest
from ..model.get_by_department_bp_response import GetByDepartmentBpResponse
from ..model.list_bp_request import ListBpRequest
from ..model.list_bp_response import ListBpResponse


class Bp(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def get_by_department(self, request: GetByDepartmentBpRequest,
                          option: Optional[RequestOption] = None) -> GetByDepartmentBpResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: GetByDepartmentBpResponse = JSON.unmarshal(str(resp.content, UTF_8), GetByDepartmentBpResponse)
        response.raw = resp

        return response

    async def aget_by_department(self, request: GetByDepartmentBpRequest,
                                 option: Optional[RequestOption] = None) -> GetByDepartmentBpResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: GetByDepartmentBpResponse = JSON.unmarshal(str(resp.content, UTF_8), GetByDepartmentBpResponse)
        response.raw = resp

        return response

    def list(self, request: ListBpRequest, option: Optional[RequestOption] = None) -> ListBpResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: ListBpResponse = JSON.unmarshal(str(resp.content, UTF_8), ListBpResponse)
        response.raw = resp

        return response

    async def alist(self, request: ListBpRequest, option: Optional[RequestOption] = None) -> ListBpResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: ListBpResponse = JSON.unmarshal(str(resp.content, UTF_8), ListBpResponse)
        response.raw = resp

        return response
