# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_cost_center_request import CreateCostCenterRequest
from ..model.create_cost_center_response import CreateCostCenterResponse
from ..model.delete_cost_center_request import DeleteCostCenterRequest
from ..model.delete_cost_center_response import DeleteCostCenterResponse
from ..model.patch_cost_center_request import PatchCostCenterRequest
from ..model.patch_cost_center_response import PatchCostCenterResponse
from ..model.search_cost_center_request import SearchCostCenterRequest
from ..model.search_cost_center_response import SearchCostCenterResponse


class CostCenter(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateCostCenterRequest,
               option: Optional[RequestOption] = None) -> CreateCostCenterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateCostCenterResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateCostCenterResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateCostCenterRequest,
                      option: Optional[RequestOption] = None) -> CreateCostCenterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateCostCenterResponse = JSON.unmarshal(str(resp.content, UTF_8), CreateCostCenterResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteCostCenterRequest,
               option: Optional[RequestOption] = None) -> DeleteCostCenterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteCostCenterResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteCostCenterResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteCostCenterRequest,
                      option: Optional[RequestOption] = None) -> DeleteCostCenterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteCostCenterResponse = JSON.unmarshal(str(resp.content, UTF_8), DeleteCostCenterResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchCostCenterRequest, option: Optional[RequestOption] = None) -> PatchCostCenterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchCostCenterResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchCostCenterResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchCostCenterRequest,
                     option: Optional[RequestOption] = None) -> PatchCostCenterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchCostCenterResponse = JSON.unmarshal(str(resp.content, UTF_8), PatchCostCenterResponse)
        response.raw = resp

        return response

    def search(self, request: SearchCostCenterRequest,
               option: Optional[RequestOption] = None) -> SearchCostCenterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SearchCostCenterResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchCostCenterResponse)
        response.raw = resp

        return response

    async def asearch(self, request: SearchCostCenterRequest,
                      option: Optional[RequestOption] = None) -> SearchCostCenterResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SearchCostCenterResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchCostCenterResponse)
        response.raw = resp

        return response
