# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.create_cost_center_version_request import CreateCostCenterVersionRequest
from ..model.create_cost_center_version_response import CreateCostCenterVersionResponse
from ..model.delete_cost_center_version_request import DeleteCostCenterVersionRequest
from ..model.delete_cost_center_version_response import DeleteCostCenterVersionResponse
from ..model.patch_cost_center_version_request import PatchCostCenterVersionRequest
from ..model.patch_cost_center_version_response import PatchCostCenterVersionResponse


class CostCenterVersion(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def create(self, request: CreateCostCenterVersionRequest,
               option: Optional[RequestOption] = None) -> CreateCostCenterVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: CreateCostCenterVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   CreateCostCenterVersionResponse)
        response.raw = resp

        return response

    async def acreate(self, request: CreateCostCenterVersionRequest,
                      option: Optional[RequestOption] = None) -> CreateCostCenterVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: CreateCostCenterVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   CreateCostCenterVersionResponse)
        response.raw = resp

        return response

    def delete(self, request: DeleteCostCenterVersionRequest,
               option: Optional[RequestOption] = None) -> DeleteCostCenterVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: DeleteCostCenterVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   DeleteCostCenterVersionResponse)
        response.raw = resp

        return response

    async def adelete(self, request: DeleteCostCenterVersionRequest,
                      option: Optional[RequestOption] = None) -> DeleteCostCenterVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: DeleteCostCenterVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                   DeleteCostCenterVersionResponse)
        response.raw = resp

        return response

    def patch(self, request: PatchCostCenterVersionRequest,
              option: Optional[RequestOption] = None) -> PatchCostCenterVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: PatchCostCenterVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  PatchCostCenterVersionResponse)
        response.raw = resp

        return response

    async def apatch(self, request: PatchCostCenterVersionRequest,
                     option: Optional[RequestOption] = None) -> PatchCostCenterVersionResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: PatchCostCenterVersionResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                  PatchCostCenterVersionResponse)
        response.raw = resp

        return response
