# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core import JSON
from lark_oapi.core.const import UTF_8, CONTENT_TYPE, APPLICATION_JSON
from lark_oapi.core.http import Transport
from lark_oapi.core.model import Config, RequestOption, RawResponse
from lark_oapi.core.token import verify
from ..model.enable_disable_assessment_probation_request import EnableDisableAssessmentProbationRequest
from ..model.enable_disable_assessment_probation_response import EnableDisableAssessmentProbationResponse
from ..model.search_probation_request import SearchProbationRequest
from ..model.search_probation_response import SearchProbationResponse


class Probation(object):
    def __init__(self, config: Config) -> None:
        self.config: Config = config

    def enable_disable_assessment(self, request: EnableDisableAssessmentProbationRequest,
                                  option: Optional[RequestOption] = None) -> EnableDisableAssessmentProbationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: EnableDisableAssessmentProbationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                            EnableDisableAssessmentProbationResponse)
        response.raw = resp

        return response

    async def aenable_disable_assessment(self, request: EnableDisableAssessmentProbationRequest, option: Optional[
        RequestOption] = None) -> EnableDisableAssessmentProbationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: EnableDisableAssessmentProbationResponse = JSON.unmarshal(str(resp.content, UTF_8),
                                                                            EnableDisableAssessmentProbationResponse)
        response.raw = resp

        return response

    def search(self, request: SearchProbationRequest,
               option: Optional[RequestOption] = None) -> SearchProbationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 添加 content-type
        if request.body is not None:
            option.headers[CONTENT_TYPE] = f"{APPLICATION_JSON}; charset=utf-8"

        # 发起请求
        resp: RawResponse = Transport.execute(self.config, request, option)

        # 反序列化
        response: SearchProbationResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchProbationResponse)
        response.raw = resp

        return response

    async def asearch(self, request: SearchProbationRequest,
                      option: Optional[RequestOption] = None) -> SearchProbationResponse:
        if option is None:
            option = RequestOption()

        # 鉴权、获取 token
        verify(self.config, request, option)

        # 发起请求
        resp: RawResponse = await Transport.aexecute(self.config, request, option)

        # 反序列化
        response: SearchProbationResponse = JSON.unmarshal(str(resp.content, UTF_8), SearchProbationResponse)
        response.raw = resp

        return response
