# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class BankEntity(object):
    _types = {
        "account_name": str,
        "bank_name": str,
        "account_number": str,
        "phone": str,
        "contacts": str,
        "tax_number": str,
        "address": str,
        "id_number": str,
        "email": str,
    }

    def __init__(self, d=None):
        self.account_name: Optional[str] = None
        self.bank_name: Optional[str] = None
        self.account_number: Optional[str] = None
        self.phone: Optional[str] = None
        self.contacts: Optional[str] = None
        self.tax_number: Optional[str] = None
        self.address: Optional[str] = None
        self.id_number: Optional[str] = None
        self.email: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BankEntityBuilder":
        return BankEntityBuilder()


class BankEntityBuilder(object):
    def __init__(self) -> None:
        self._bank_entity = BankEntity()

    def account_name(self, account_name: str) -> "BankEntityBuilder":
        self._bank_entity.account_name = account_name
        return self

    def bank_name(self, bank_name: str) -> "BankEntityBuilder":
        self._bank_entity.bank_name = bank_name
        return self

    def account_number(self, account_number: str) -> "BankEntityBuilder":
        self._bank_entity.account_number = account_number
        return self

    def phone(self, phone: str) -> "BankEntityBuilder":
        self._bank_entity.phone = phone
        return self

    def contacts(self, contacts: str) -> "BankEntityBuilder":
        self._bank_entity.contacts = contacts
        return self

    def tax_number(self, tax_number: str) -> "BankEntityBuilder":
        self._bank_entity.tax_number = tax_number
        return self

    def address(self, address: str) -> "BankEntityBuilder":
        self._bank_entity.address = address
        return self

    def id_number(self, id_number: str) -> "BankEntityBuilder":
        self._bank_entity.id_number = id_number
        return self

    def email(self, email: str) -> "BankEntityBuilder":
        self._bank_entity.email = email
        return self

    def build(self) -> "BankEntity":
        return self._bank_entity
