# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init
from .bank_entity import BankEntity


class BankInfo(object):
    _types = {
        "bank_type": str,
        "value": BankEntity,
    }

    def __init__(self, d=None):
        self.bank_type: Optional[str] = None
        self.value: Optional[BankEntity] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BankInfoBuilder":
        return BankInfoBuilder()


class BankInfoBuilder(object):
    def __init__(self) -> None:
        self._bank_info = BankInfo()

    def bank_type(self, bank_type: str) -> "BankInfoBuilder":
        self._bank_info.bank_type = bank_type
        return self

    def value(self, value: BankEntity) -> "BankInfoBuilder":
        self._bank_info.value = value
        return self

    def build(self) -> "BankInfo":
        return self._bank_info
