# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class BodyEntity(object):
    _types = {
        "address": str,
        "contacts": str,
        "email": str,
        "phone": str,
        "id_number": str,
        "legal_representative": str,
        "party": str,
    }

    def __init__(self, d=None):
        self.address: Optional[str] = None
        self.contacts: Optional[str] = None
        self.email: Optional[str] = None
        self.phone: Optional[str] = None
        self.id_number: Optional[str] = None
        self.legal_representative: Optional[str] = None
        self.party: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BodyEntityBuilder":
        return BodyEntityBuilder()


class BodyEntityBuilder(object):
    def __init__(self) -> None:
        self._body_entity = BodyEntity()

    def address(self, address: str) -> "BodyEntityBuilder":
        self._body_entity.address = address
        return self

    def contacts(self, contacts: str) -> "BodyEntityBuilder":
        self._body_entity.contacts = contacts
        return self

    def email(self, email: str) -> "BodyEntityBuilder":
        self._body_entity.email = email
        return self

    def phone(self, phone: str) -> "BodyEntityBuilder":
        self._body_entity.phone = phone
        return self

    def id_number(self, id_number: str) -> "BodyEntityBuilder":
        self._body_entity.id_number = id_number
        return self

    def legal_representative(self, legal_representative: str) -> "BodyEntityBuilder":
        self._body_entity.legal_representative = legal_representative
        return self

    def party(self, party: str) -> "BodyEntityBuilder":
        self._body_entity.party = party
        return self

    def build(self) -> "BodyEntity":
        return self._body_entity
