# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Currency(object):
    _types = {
        "currency_name": str,
        "currency_text": str,
    }

    def __init__(self, d=None):
        self.currency_name: Optional[str] = None
        self.currency_text: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CurrencyBuilder":
        return CurrencyBuilder()


class CurrencyBuilder(object):
    def __init__(self) -> None:
        self._currency = Currency()

    def currency_name(self, currency_name: str) -> "CurrencyBuilder":
        self._currency.currency_name = currency_name
        return self

    def currency_text(self, currency_text: str) -> "CurrencyBuilder":
        self._currency.currency_text = currency_text
        return self

    def build(self) -> "Currency":
        return self._currency
