# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ExtractCopy(object):
    _types = {
        "copy_num": int,
        "original_copy": str,
        "key": str,
        "text": str,
    }

    def __init__(self, d=None):
        self.copy_num: Optional[int] = None
        self.original_copy: Optional[str] = None
        self.key: Optional[str] = None
        self.text: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ExtractCopyBuilder":
        return ExtractCopyBuilder()


class ExtractCopyBuilder(object):
    def __init__(self) -> None:
        self._extract_copy = ExtractCopy()

    def copy_num(self, copy_num: int) -> "ExtractCopyBuilder":
        self._extract_copy.copy_num = copy_num
        return self

    def original_copy(self, original_copy: str) -> "ExtractCopyBuilder":
        self._extract_copy.original_copy = original_copy
        return self

    def key(self, key: str) -> "ExtractCopyBuilder":
        self._extract_copy.key = key
        return self

    def text(self, text: str) -> "ExtractCopyBuilder":
        self._extract_copy.text = text
        return self

    def build(self) -> "ExtractCopy":
        return self._extract_copy
