# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ExtractPrice(object):
    _types = {
        "contract_price": float,
        "contract_price_original": str,
        "text": str,
    }

    def __init__(self, d=None):
        self.contract_price: Optional[float] = None
        self.contract_price_original: Optional[str] = None
        self.text: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ExtractPriceBuilder":
        return ExtractPriceBuilder()


class ExtractPriceBuilder(object):
    def __init__(self) -> None:
        self._extract_price = ExtractPrice()

    def contract_price(self, contract_price: float) -> "ExtractPriceBuilder":
        self._extract_price.contract_price = contract_price
        return self

    def contract_price_original(self, contract_price_original: str) -> "ExtractPriceBuilder":
        self._extract_price.contract_price_original = contract_price_original
        return self

    def text(self, text: str) -> "ExtractPriceBuilder":
        self._extract_price.text = text
        return self

    def build(self) -> "ExtractPrice":
        return self._extract_price
