# Code generated by Lark OpenAPI.

from typing import Any, Optional, IO

from lark_oapi.core.construct import init


class FieldExtractionContractRequestBody(object):
    _types = {
        "file": IO[Any],
        "pdf_page_limit": int,
        "ocr_mode": str,
    }

    def __init__(self, d=None):
        self.file: Optional[IO[Any]] = None
        self.pdf_page_limit: Optional[int] = None
        self.ocr_mode: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FieldExtractionContractRequestBodyBuilder":
        return FieldExtractionContractRequestBodyBuilder()


class FieldExtractionContractRequestBodyBuilder(object):
    def __init__(self) -> None:
        self._field_extraction_contract_request_body = FieldExtractionContractRequestBody()

    def file(self, file: IO[Any]) -> "FieldExtractionContractRequestBodyBuilder":
        self._field_extraction_contract_request_body.file = file
        return self

    def pdf_page_limit(self, pdf_page_limit: int) -> "FieldExtractionContractRequestBodyBuilder":
        self._field_extraction_contract_request_body.pdf_page_limit = pdf_page_limit
        return self

    def ocr_mode(self, ocr_mode: str) -> "FieldExtractionContractRequestBodyBuilder":
        self._field_extraction_contract_request_body.ocr_mode = ocr_mode
        return self

    def build(self) -> "FieldExtractionContractRequestBody":
        return self._field_extraction_contract_request_body
