# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .bank_info import BankInfo
from .body_info import BodyInfo
from .extract_copy import ExtractCopy
from .extract_currency import ExtractCurrency
from .extract_price import ExtractPrice
from .extract_time import ExtractTime


class FieldExtractionContractResponseBody(object):
    _types = {
        "file_id": str,
        "price": ExtractPrice,
        "time": ExtractTime,
        "copy": ExtractCopy,
        "currency": ExtractCurrency,
        "header": str,
        "body_info": List[BodyInfo],
        "bank_info": List[BankInfo],
    }

    def __init__(self, d=None):
        self.file_id: Optional[str] = None
        self.price: Optional[ExtractPrice] = None
        self.time: Optional[ExtractTime] = None
        self.copy: Optional[ExtractCopy] = None
        self.currency: Optional[ExtractCurrency] = None
        self.header: Optional[str] = None
        self.body_info: Optional[List[BodyInfo]] = None
        self.bank_info: Optional[List[BankInfo]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "FieldExtractionContractResponseBodyBuilder":
        return FieldExtractionContractResponseBodyBuilder()


class FieldExtractionContractResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._field_extraction_contract_response_body = FieldExtractionContractResponseBody()

    def file_id(self, file_id: str) -> "FieldExtractionContractResponseBodyBuilder":
        self._field_extraction_contract_response_body.file_id = file_id
        return self

    def price(self, price: ExtractPrice) -> "FieldExtractionContractResponseBodyBuilder":
        self._field_extraction_contract_response_body.price = price
        return self

    def time(self, time: ExtractTime) -> "FieldExtractionContractResponseBodyBuilder":
        self._field_extraction_contract_response_body.time = time
        return self

    def copy(self, copy: ExtractCopy) -> "FieldExtractionContractResponseBodyBuilder":
        self._field_extraction_contract_response_body.copy = copy
        return self

    def currency(self, currency: ExtractCurrency) -> "FieldExtractionContractResponseBodyBuilder":
        self._field_extraction_contract_response_body.currency = currency
        return self

    def header(self, header: str) -> "FieldExtractionContractResponseBodyBuilder":
        self._field_extraction_contract_response_body.header = header
        return self

    def body_info(self, body_info: List[BodyInfo]) -> "FieldExtractionContractResponseBodyBuilder":
        self._field_extraction_contract_response_body.body_info = body_info
        return self

    def bank_info(self, bank_info: List[BankInfo]) -> "FieldExtractionContractResponseBodyBuilder":
        self._field_extraction_contract_response_body.bank_info = bank_info
        return self

    def build(self) -> "FieldExtractionContractResponseBody":
        return self._field_extraction_contract_response_body
