# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .id_entity import IdEntity


class IdCard(object):
    _types = {
        "entities": List[IdEntity],
        "side": int,
        "conners": List[int],
    }

    def __init__(self, d=None):
        self.entities: Optional[List[IdEntity]] = None
        self.side: Optional[int] = None
        self.conners: Optional[List[int]] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "IdCardBuilder":
        return IdCardBuilder()


class IdCardBuilder(object):
    def __init__(self) -> None:
        self._id_card = IdCard()

    def entities(self, entities: List[IdEntity]) -> "IdCardBuilder":
        self._id_card.entities = entities
        return self

    def side(self, side: int) -> "IdCardBuilder":
        self._id_card.side = side
        return self

    def conners(self, conners: List[int]) -> "IdCardBuilder":
        self._id_card.conners = conners
        return self

    def build(self) -> "IdCard":
        return self._id_card
