# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_bank_card_request_body import RecognizeBankCardRequestBody


class RecognizeBankCardRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeBankCardRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeBankCardRequestBuilder":
        return RecognizeBankCardRequestBuilder()


class RecognizeBankCardRequestBuilder(object):

    def __init__(self) -> None:
        recognize_bank_card_request = RecognizeBankCardRequest()
        recognize_bank_card_request.http_method = HttpMethod.POST
        recognize_bank_card_request.uri = "/open-apis/document_ai/v1/bank_card/recognize"
        recognize_bank_card_request.token_types = {AccessTokenType.TENANT}
        self._recognize_bank_card_request: RecognizeBankCardRequest = recognize_bank_card_request

    def request_body(self, request_body: RecognizeBankCardRequestBody) -> "RecognizeBankCardRequestBuilder":
        self._recognize_bank_card_request.request_body = request_body
        self._recognize_bank_card_request.body = request_body
        return self

    def build(self) -> RecognizeBankCardRequest:
        return self._recognize_bank_card_request
