# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_driving_license_request_body import RecognizeDrivingLicenseRequestBody


class RecognizeDrivingLicenseRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeDrivingLicenseRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeDrivingLicenseRequestBuilder":
        return RecognizeDrivingLicenseRequestBuilder()


class RecognizeDrivingLicenseRequestBuilder(object):

    def __init__(self) -> None:
        recognize_driving_license_request = RecognizeDrivingLicenseRequest()
        recognize_driving_license_request.http_method = HttpMethod.POST
        recognize_driving_license_request.uri = "/open-apis/document_ai/v1/driving_license/recognize"
        recognize_driving_license_request.token_types = {AccessTokenType.TENANT}
        self._recognize_driving_license_request: RecognizeDrivingLicenseRequest = recognize_driving_license_request

    def request_body(self, request_body: RecognizeDrivingLicenseRequestBody) -> "RecognizeDrivingLicenseRequestBuilder":
        self._recognize_driving_license_request.request_body = request_body
        self._recognize_driving_license_request.body = request_body
        return self

    def build(self) -> RecognizeDrivingLicenseRequest:
        return self._recognize_driving_license_request
