# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_food_manage_license_request_body import RecognizeFoodManageLicenseRequestBody


class RecognizeFoodManageLicenseRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeFoodManageLicenseRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeFoodManageLicenseRequestBuilder":
        return RecognizeFoodManageLicenseRequestBuilder()


class RecognizeFoodManageLicenseRequestBuilder(object):

    def __init__(self) -> None:
        recognize_food_manage_license_request = RecognizeFoodManageLicenseRequest()
        recognize_food_manage_license_request.http_method = HttpMethod.POST
        recognize_food_manage_license_request.uri = "/open-apis/document_ai/v1/food_manage_license/recognize"
        recognize_food_manage_license_request.token_types = {AccessTokenType.TENANT}
        self._recognize_food_manage_license_request: RecognizeFoodManageLicenseRequest = recognize_food_manage_license_request

    def request_body(self,
                     request_body: RecognizeFoodManageLicenseRequestBody) -> "RecognizeFoodManageLicenseRequestBuilder":
        self._recognize_food_manage_license_request.request_body = request_body
        self._recognize_food_manage_license_request.body = request_body
        return self

    def build(self) -> RecognizeFoodManageLicenseRequest:
        return self._recognize_food_manage_license_request
