# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_food_produce_license_request_body import RecognizeFoodProduceLicenseRequestBody


class RecognizeFoodProduceLicenseRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeFoodProduceLicenseRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeFoodProduceLicenseRequestBuilder":
        return RecognizeFoodProduceLicenseRequestBuilder()


class RecognizeFoodProduceLicenseRequestBuilder(object):

    def __init__(self) -> None:
        recognize_food_produce_license_request = RecognizeFoodProduceLicenseRequest()
        recognize_food_produce_license_request.http_method = HttpMethod.POST
        recognize_food_produce_license_request.uri = "/open-apis/document_ai/v1/food_produce_license/recognize"
        recognize_food_produce_license_request.token_types = {AccessTokenType.TENANT}
        self._recognize_food_produce_license_request: RecognizeFoodProduceLicenseRequest = recognize_food_produce_license_request

    def request_body(self,
                     request_body: RecognizeFoodProduceLicenseRequestBody) -> "RecognizeFoodProduceLicenseRequestBuilder":
        self._recognize_food_produce_license_request.request_body = request_body
        self._recognize_food_produce_license_request.body = request_body
        return self

    def build(self) -> RecognizeFoodProduceLicenseRequest:
        return self._recognize_food_produce_license_request
