# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_health_certificate_request_body import RecognizeHealthCertificateRequestBody


class RecognizeHealthCertificateRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeHealthCertificateRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeHealthCertificateRequestBuilder":
        return RecognizeHealthCertificateRequestBuilder()


class RecognizeHealthCertificateRequestBuilder(object):

    def __init__(self) -> None:
        recognize_health_certificate_request = RecognizeHealthCertificateRequest()
        recognize_health_certificate_request.http_method = HttpMethod.POST
        recognize_health_certificate_request.uri = "/open-apis/document_ai/v1/health_certificate/recognize"
        recognize_health_certificate_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._recognize_health_certificate_request: RecognizeHealthCertificateRequest = recognize_health_certificate_request

    def request_body(self,
                     request_body: RecognizeHealthCertificateRequestBody) -> "RecognizeHealthCertificateRequestBuilder":
        self._recognize_health_certificate_request.request_body = request_body
        self._recognize_health_certificate_request.body = request_body
        return self

    def build(self) -> RecognizeHealthCertificateRequest:
        return self._recognize_health_certificate_request
