# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_hkm_mainland_travel_permit_request_body import RecognizeHkmMainlandTravelPermitRequestBody


class RecognizeHkmMainlandTravelPermitRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeHkmMainlandTravelPermitRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeHkmMainlandTravelPermitRequestBuilder":
        return RecognizeHkmMainlandTravelPermitRequestBuilder()


class RecognizeHkmMainlandTravelPermitRequestBuilder(object):

    def __init__(self) -> None:
        recognize_hkm_mainland_travel_permit_request = RecognizeHkmMainlandTravelPermitRequest()
        recognize_hkm_mainland_travel_permit_request.http_method = HttpMethod.POST
        recognize_hkm_mainland_travel_permit_request.uri = "/open-apis/document_ai/v1/hkm_mainland_travel_permit/recognize"
        recognize_hkm_mainland_travel_permit_request.token_types = {AccessTokenType.TENANT}
        self._recognize_hkm_mainland_travel_permit_request: RecognizeHkmMainlandTravelPermitRequest = recognize_hkm_mainland_travel_permit_request

    def request_body(self,
                     request_body: RecognizeHkmMainlandTravelPermitRequestBody) -> "RecognizeHkmMainlandTravelPermitRequestBuilder":
        self._recognize_hkm_mainland_travel_permit_request.request_body = request_body
        self._recognize_hkm_mainland_travel_permit_request.body = request_body
        return self

    def build(self) -> RecognizeHkmMainlandTravelPermitRequest:
        return self._recognize_hkm_mainland_travel_permit_request
