# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_train_invoice_request_body import RecognizeTrainInvoiceRequestBody


class RecognizeTrainInvoiceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeTrainInvoiceRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeTrainInvoiceRequestBuilder":
        return RecognizeTrainInvoiceRequestBuilder()


class RecognizeTrainInvoiceRequestBuilder(object):

    def __init__(self) -> None:
        recognize_train_invoice_request = RecognizeTrainInvoiceRequest()
        recognize_train_invoice_request.http_method = HttpMethod.POST
        recognize_train_invoice_request.uri = "/open-apis/document_ai/v1/train_invoice/recognize"
        recognize_train_invoice_request.token_types = {AccessTokenType.TENANT}
        self._recognize_train_invoice_request: RecognizeTrainInvoiceRequest = recognize_train_invoice_request

    def request_body(self, request_body: RecognizeTrainInvoiceRequestBody) -> "RecognizeTrainInvoiceRequestBuilder":
        self._recognize_train_invoice_request.request_body = request_body
        self._recognize_train_invoice_request.body = request_body
        return self

    def build(self) -> RecognizeTrainInvoiceRequest:
        return self._recognize_train_invoice_request
