# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_vat_invoice_request_body import RecognizeVatInvoiceRequestBody


class RecognizeVatInvoiceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeVatInvoiceRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeVatInvoiceRequestBuilder":
        return RecognizeVatInvoiceRequestBuilder()


class RecognizeVatInvoiceRequestBuilder(object):

    def __init__(self) -> None:
        recognize_vat_invoice_request = RecognizeVatInvoiceRequest()
        recognize_vat_invoice_request.http_method = HttpMethod.POST
        recognize_vat_invoice_request.uri = "/open-apis/document_ai/v1/vat_invoice/recognize"
        recognize_vat_invoice_request.token_types = {AccessTokenType.TENANT}
        self._recognize_vat_invoice_request: RecognizeVatInvoiceRequest = recognize_vat_invoice_request

    def request_body(self, request_body: RecognizeVatInvoiceRequestBody) -> "RecognizeVatInvoiceRequestBuilder":
        self._recognize_vat_invoice_request.request_body = request_body
        self._recognize_vat_invoice_request.body = request_body
        return self

    def build(self) -> RecognizeVatInvoiceRequest:
        return self._recognize_vat_invoice_request
