# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_vehicle_invoice_request_body import RecognizeVehicleInvoiceRequestBody


class RecognizeVehicleInvoiceRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeVehicleInvoiceRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeVehicleInvoiceRequestBuilder":
        return RecognizeVehicleInvoiceRequestBuilder()


class RecognizeVehicleInvoiceRequestBuilder(object):

    def __init__(self) -> None:
        recognize_vehicle_invoice_request = RecognizeVehicleInvoiceRequest()
        recognize_vehicle_invoice_request.http_method = HttpMethod.POST
        recognize_vehicle_invoice_request.uri = "/open-apis/document_ai/v1/vehicle_invoice/recognize"
        recognize_vehicle_invoice_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._recognize_vehicle_invoice_request: RecognizeVehicleInvoiceRequest = recognize_vehicle_invoice_request

    def request_body(self, request_body: RecognizeVehicleInvoiceRequestBody) -> "RecognizeVehicleInvoiceRequestBuilder":
        self._recognize_vehicle_invoice_request.request_body = request_body
        self._recognize_vehicle_invoice_request.body = request_body
        return self

    def build(self) -> RecognizeVehicleInvoiceRequest:
        return self._recognize_vehicle_invoice_request
