# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest
from .recognize_vehicle_license_request_body import RecognizeVehicleLicenseRequestBody


class RecognizeVehicleLicenseRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.request_body: Optional[RecognizeVehicleLicenseRequestBody] = None

    @staticmethod
    def builder() -> "RecognizeVehicleLicenseRequestBuilder":
        return RecognizeVehicleLicenseRequestBuilder()


class RecognizeVehicleLicenseRequestBuilder(object):

    def __init__(self) -> None:
        recognize_vehicle_license_request = RecognizeVehicleLicenseRequest()
        recognize_vehicle_license_request.http_method = HttpMethod.POST
        recognize_vehicle_license_request.uri = "/open-apis/document_ai/v1/vehicle_license/recognize"
        recognize_vehicle_license_request.token_types = {AccessTokenType.TENANT}
        self._recognize_vehicle_license_request: RecognizeVehicleLicenseRequest = recognize_vehicle_license_request

    def request_body(self, request_body: RecognizeVehicleLicenseRequestBody) -> "RecognizeVehicleLicenseRequestBuilder":
        self._recognize_vehicle_license_request.request_body = request_body
        self._recognize_vehicle_license_request.body = request_body
        return self

    def build(self) -> RecognizeVehicleLicenseRequest:
        return self._recognize_vehicle_license_request
