# Code generated by Lark OpenAPI.

from typing import Optional, List

from lark_oapi.core.construct import init
from .block import Block


class BatchUpdateDocumentBlockResponseBody(object):
    _types = {
        "blocks": List[Block],
        "document_revision_id": int,
        "client_token": str,
    }

    def __init__(self, d=None):
        self.blocks: Optional[List[Block]] = None
        self.document_revision_id: Optional[int] = None
        self.client_token: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BatchUpdateDocumentBlockResponseBodyBuilder":
        return BatchUpdateDocumentBlockResponseBodyBuilder()


class BatchUpdateDocumentBlockResponseBodyBuilder(object):
    def __init__(self) -> None:
        self._batch_update_document_block_response_body = BatchUpdateDocumentBlockResponseBody()

    def blocks(self, blocks: List[Block]) -> "BatchUpdateDocumentBlockResponseBodyBuilder":
        self._batch_update_document_block_response_body.blocks = blocks
        return self

    def document_revision_id(self, document_revision_id: int) -> "BatchUpdateDocumentBlockResponseBodyBuilder":
        self._batch_update_document_block_response_body.document_revision_id = document_revision_id
        return self

    def client_token(self, client_token: str) -> "BatchUpdateDocumentBlockResponseBodyBuilder":
        self._batch_update_document_block_response_body.client_token = client_token
        return self

    def build(self) -> "BatchUpdateDocumentBlockResponseBody":
        return self._batch_update_document_block_response_body
