# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Bitable(object):
    _types = {
        "token": str,
        "view_type": int,
    }

    def __init__(self, d=None):
        self.token: Optional[str] = None
        self.view_type: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BitableBuilder":
        return BitableBuilder()


class BitableBuilder(object):
    def __init__(self) -> None:
        self._bitable = Bitable()

    def token(self, token: str) -> "BitableBuilder":
        self._bitable.token = token
        return self

    def view_type(self, view_type: int) -> "BitableBuilder":
        self._bitable.view_type = view_type
        return self

    def build(self) -> "Bitable":
        return self._bitable
