# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Board(object):
    _types = {
        "token": str,
        "align": int,
        "width": int,
        "height": int,
    }

    def __init__(self, d=None):
        self.token: Optional[str] = None
        self.align: Optional[int] = None
        self.width: Optional[int] = None
        self.height: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "BoardBuilder":
        return BoardBuilder()


class BoardBuilder(object):
    def __init__(self) -> None:
        self._board = Board()

    def token(self, token: str) -> "BoardBuilder":
        self._board.token = token
        return self

    def align(self, align: int) -> "BoardBuilder":
        self._board.align = align
        return self

    def width(self, width: int) -> "BoardBuilder":
        self._board.width = width
        return self

    def height(self, height: int) -> "BoardBuilder":
        self._board.height = height
        return self

    def build(self) -> "Board":
        return self._board
