# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class Callout(object):
    _types = {
        "background_color": int,
        "border_color": int,
        "text_color": int,
        "emoji_id": str,
    }

    def __init__(self, d=None):
        self.background_color: Optional[int] = None
        self.border_color: Optional[int] = None
        self.text_color: Optional[int] = None
        self.emoji_id: Optional[str] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "CalloutBuilder":
        return CalloutBuilder()


class CalloutBuilder(object):
    def __init__(self) -> None:
        self._callout = Callout()

    def background_color(self, background_color: int) -> "CalloutBuilder":
        self._callout.background_color = background_color
        return self

    def border_color(self, border_color: int) -> "CalloutBuilder":
        self._callout.border_color = border_color
        return self

    def text_color(self, text_color: int) -> "CalloutBuilder":
        self._callout.text_color = text_color
        return self

    def emoji_id(self, emoji_id: str) -> "CalloutBuilder":
        self._callout.emoji_id = emoji_id
        return self

    def build(self) -> "Callout":
        return self._callout
