# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class ChatCard(object):
    _types = {
        "chat_id": int,
        "align": int,
    }

    def __init__(self, d=None):
        self.chat_id: Optional[int] = None
        self.align: Optional[int] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "ChatCardBuilder":
        return ChatCardBuilder()


class ChatCardBuilder(object):
    def __init__(self) -> None:
        self._chat_card = ChatCard()

    def chat_id(self, chat_id: int) -> "ChatCardBuilder":
        self._chat_card.chat_id = chat_id
        return self

    def align(self, align: int) -> "ChatCardBuilder":
        self._chat_card.align = align
        return self

    def build(self) -> "ChatCard":
        return self._chat_card
