# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.construct import init


class DocumentDisplaySetting(object):
    _types = {
        "show_authors": bool,
        "show_create_time": bool,
        "show_pv": bool,
        "show_uv": bool,
        "show_like_count": bool,
        "show_comment_count": bool,
        "show_related_matters": bool,
    }

    def __init__(self, d=None):
        self.show_authors: Optional[bool] = None
        self.show_create_time: Optional[bool] = None
        self.show_pv: Optional[bool] = None
        self.show_uv: Optional[bool] = None
        self.show_like_count: Optional[bool] = None
        self.show_comment_count: Optional[bool] = None
        self.show_related_matters: Optional[bool] = None
        init(self, d, self._types)

    @staticmethod
    def builder() -> "DocumentDisplaySettingBuilder":
        return DocumentDisplaySettingBuilder()


class DocumentDisplaySettingBuilder(object):
    def __init__(self) -> None:
        self._document_display_setting = DocumentDisplaySetting()

    def show_authors(self, show_authors: bool) -> "DocumentDisplaySettingBuilder":
        self._document_display_setting.show_authors = show_authors
        return self

    def show_create_time(self, show_create_time: bool) -> "DocumentDisplaySettingBuilder":
        self._document_display_setting.show_create_time = show_create_time
        return self

    def show_pv(self, show_pv: bool) -> "DocumentDisplaySettingBuilder":
        self._document_display_setting.show_pv = show_pv
        return self

    def show_uv(self, show_uv: bool) -> "DocumentDisplaySettingBuilder":
        self._document_display_setting.show_uv = show_uv
        return self

    def show_like_count(self, show_like_count: bool) -> "DocumentDisplaySettingBuilder":
        self._document_display_setting.show_like_count = show_like_count
        return self

    def show_comment_count(self, show_comment_count: bool) -> "DocumentDisplaySettingBuilder":
        self._document_display_setting.show_comment_count = show_comment_count
        return self

    def show_related_matters(self, show_related_matters: bool) -> "DocumentDisplaySettingBuilder":
        self._document_display_setting.show_related_matters = show_related_matters
        return self

    def build(self) -> "DocumentDisplaySetting":
        return self._document_display_setting
