# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetDocumentBlockRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.document_revision_id: Optional[int] = None
        self.user_id_type: Optional[str] = None
        self.document_id: Optional[str] = None
        self.block_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetDocumentBlockRequestBuilder":
        return GetDocumentBlockRequestBuilder()


class GetDocumentBlockRequestBuilder(object):

    def __init__(self) -> None:
        get_document_block_request = GetDocumentBlockRequest()
        get_document_block_request.http_method = HttpMethod.GET
        get_document_block_request.uri = "/open-apis/docx/v1/documents/:document_id/blocks/:block_id"
        get_document_block_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_document_block_request: GetDocumentBlockRequest = get_document_block_request

    def document_revision_id(self, document_revision_id: int) -> "GetDocumentBlockRequestBuilder":
        self._get_document_block_request.document_revision_id = document_revision_id
        self._get_document_block_request.add_query("document_revision_id", document_revision_id)
        return self

    def user_id_type(self, user_id_type: str) -> "GetDocumentBlockRequestBuilder":
        self._get_document_block_request.user_id_type = user_id_type
        self._get_document_block_request.add_query("user_id_type", user_id_type)
        return self

    def document_id(self, document_id: str) -> "GetDocumentBlockRequestBuilder":
        self._get_document_block_request.document_id = document_id
        self._get_document_block_request.paths["document_id"] = str(document_id)
        return self

    def block_id(self, block_id: str) -> "GetDocumentBlockRequestBuilder":
        self._get_document_block_request.block_id = block_id
        self._get_document_block_request.paths["block_id"] = str(block_id)
        return self

    def build(self) -> GetDocumentBlockRequest:
        return self._get_document_block_request
