# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class GetDocumentRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.document_id: Optional[str] = None

    @staticmethod
    def builder() -> "GetDocumentRequestBuilder":
        return GetDocumentRequestBuilder()


class GetDocumentRequestBuilder(object):

    def __init__(self) -> None:
        get_document_request = GetDocumentRequest()
        get_document_request.http_method = HttpMethod.GET
        get_document_request.uri = "/open-apis/docx/v1/documents/:document_id"
        get_document_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._get_document_request: GetDocumentRequest = get_document_request

    def document_id(self, document_id: str) -> "GetDocumentRequestBuilder":
        self._get_document_request.document_id = document_id
        self._get_document_request.paths["document_id"] = str(document_id)
        return self

    def build(self) -> GetDocumentRequest:
        return self._get_document_request
