# Code generated by Lark OpenAPI.

from typing import Optional

from lark_oapi.core.enum import HttpMethod, AccessTokenType
from lark_oapi.core.model import BaseRequest


class ListDocumentBlockRequest(BaseRequest):
    def __init__(self) -> None:
        super().__init__()
        self.page_size: Optional[int] = None
        self.page_token: Optional[str] = None
        self.document_revision_id: Optional[int] = None
        self.user_id_type: Optional[str] = None
        self.document_id: Optional[str] = None

    @staticmethod
    def builder() -> "ListDocumentBlockRequestBuilder":
        return ListDocumentBlockRequestBuilder()


class ListDocumentBlockRequestBuilder(object):

    def __init__(self) -> None:
        list_document_block_request = ListDocumentBlockRequest()
        list_document_block_request.http_method = HttpMethod.GET
        list_document_block_request.uri = "/open-apis/docx/v1/documents/:document_id/blocks"
        list_document_block_request.token_types = {AccessTokenType.TENANT, AccessTokenType.USER}
        self._list_document_block_request: ListDocumentBlockRequest = list_document_block_request

    def page_size(self, page_size: int) -> "ListDocumentBlockRequestBuilder":
        self._list_document_block_request.page_size = page_size
        self._list_document_block_request.add_query("page_size", page_size)
        return self

    def page_token(self, page_token: str) -> "ListDocumentBlockRequestBuilder":
        self._list_document_block_request.page_token = page_token
        self._list_document_block_request.add_query("page_token", page_token)
        return self

    def document_revision_id(self, document_revision_id: int) -> "ListDocumentBlockRequestBuilder":
        self._list_document_block_request.document_revision_id = document_revision_id
        self._list_document_block_request.add_query("document_revision_id", document_revision_id)
        return self

    def user_id_type(self, user_id_type: str) -> "ListDocumentBlockRequestBuilder":
        self._list_document_block_request.user_id_type = user_id_type
        self._list_document_block_request.add_query("user_id_type", user_id_type)
        return self

    def document_id(self, document_id: str) -> "ListDocumentBlockRequestBuilder":
        self._list_document_block_request.document_id = document_id
        self._list_document_block_request.paths["document_id"] = str(document_id)
        return self

    def build(self) -> ListDocumentBlockRequest:
        return self._list_document_block_request
